import {CategoryChildren, CategoryI} from "../../../../src/types/category";
import {settingsFromDatabase} from "../../../../src/types/settings";


export interface createCategoryI {
    categoryName: string;
    packFolderName: string;
    children: CategoryChildren[]
    settings?: settingsFromDatabase | undefined;
    previews?: string[] | undefined;
    icon?: string | undefined;
    parentPath?: string[] | undefined;
}

export default function createCategory({
                                           categoryName,
                                           children,
                                           packFolderName,
                                           settings = undefined,
                                           previews = undefined,
                                           icon = undefined,
                                           parentPath = undefined
                                       }: createCategoryI): CategoryI {

    return {
        name: categoryName,
        path: `D:\\temp\\MotionBro\\${packFolderName}_by_Videolancer${parentPath ? "\\" + parentPath.join("\\") : ""}\\${categoryName}`,
        type: "category",
        children: children,
        settings: settings,
        previews: previews,
        icon: icon
    }
}